<?php

/***
	{
		Module: photocrati-nextgen_gallery_display
	}
***/

define('NGG_DISPLAY_SETTINGS_SLUG', 'ngg_display_settings');
define('NGG_DISPLAY_PRIORITY_BASE', 10000);
define('NGG_DISPLAY_PRIORITY_STEP', 2000);
if (!defined('NGG_RENDERING_CACHE_TTL')) define('NGG_RENDERING_CACHE_TTL', PHOTOCRATI_CACHE_TTL);
if (!defined('NGG_DISPLAYED_GALLERY_CACHE_TTL')) define('NGG_DISPLAYED_GALLERY_CACHE_TTL', PHOTOCRATI_CACHE_TTL);

class M_Gallery_Display extends C_Base_Module
{
	function define()
	{
		parent::define(
			'photocrati-nextgen_gallery_display',
			'Gallery Display',
			'Provides the ability to display gallery of images',
			'0.9',
			'http://www.photocrati.com',
			'Photocrati Media',
			'http://www.photocrati.com'
		);

		include_once('class.gallery_display_installer.php');
		C_Photocrati_Installer::add_handler($this->module_id, 'C_Gallery_Display_Installer');
	}


	/**
	 * Register utilities required for this module
	 */
	function _register_utilities()
	{
		// This utility provides a controller to render the settings form
		// for a display type, or render the front-end of a display type
		$this->get_registry()->add_utility(
			'I_Display_Type_Controller',
			'C_Display_Type_Controller'
		);

		// This utility provides a datamapper for Display Types
		$this->get_registry()->add_utility(
			'I_Display_Type_Mapper',
			'C_Display_Type_Mapper'
		);

		// This utility provides a datamapper for Displayed Galleries. A
		// displayed gallery is the association between some entities (images
		//or galleries) and a display type
		$this->get_registry()->add_utility(
			'I_Displayed_Gallery_Mapper',
			'C_Displayed_Gallery_Mapper'
		);

		// This utility provides a datamapper for Displayed Gallery Sources. A
		// source instructs a displayed gallery where the entities are to be
		// fetched from - e.g. galleries, albums, etc.
		$this->get_registry()->add_utility(
			'I_Displayed_Gallery_Source_Mapper',
			'C_Displayed_Gallery_Source_Mapper'
		);

        // This utility provides the capabilities of rendering a display type
        $this->get_registry()->add_utility(
            'I_Displayed_Gallery_Renderer',
            'C_Displayed_Gallery_Renderer'
        );
	}

	/**
	 * Registers adapters required for this module
	 */
	function _register_adapters()
	{
		// Provides factory methods for creating display type and
		// displayed gallery instances
		$this->get_registry()->add_adapter(
			'I_Component_Factory', 'A_Gallery_Display_Factory'
		);

        if (is_admin()) {
            $this->get_registry()->add_adapter(
                'I_Page_Manager',
                'A_Display_Settings_Page'
            );
        }

		$this->_get_registry()->add_adapter(
			'I_Ajax_Controller',
			'A_Gallery_Display_Ajax'
		);

		$this->get_registry()->add_adapter('I_MVC_View', 'A_Gallery_Display_View');
        $this->get_registry()->add_adapter('I_MVC_View', 'A_Displayed_Gallery_Trigger_Element');
	}

	/**
	 * Registers hooks for the WordPress framework
	 */
	function _register_hooks()
	{
		// Add a shortcode for displaying galleries
		C_NextGen_Shortcode_Manager::add('ngg_images', array(&$this, 'display_images'));
        add_action('init', array(&$this, '_register_resources'));
        add_action('admin_bar_menu', array(&$this, 'add_admin_bar_menu'), 100);
        add_filter('the_content', array($this, '_render_related_images'));
		add_action('wp_enqueue_scripts', array(&$this, 'no_resources_mode'), PHP_INT_MAX-1);
		add_filter('run_ngg_resource_manager', array(&$this, 'no_resources_mode'));
        add_action('init', array(&$this, 'serve_fontawesome'), 15);
	}

    /**
     * Serves the fontawesome woff file via PHP. We do this, as IIS won't serve .woff files.
     * @throws E_Clean_Exit
     */
    function serve_fontawesome()
    {
        if (isset($_REQUEST['ngg_serve_fontawesome_woff'])) {
            $fs = C_Fs::get_instance();
            $abspath = $fs->find_static_abspath('photocrati-nextgen_gallery_display#fonts/fontawesome-webfont.woff');
            if ($abspath) {
                header("Content-Type: application/x-font-woff");
                readfile($abspath);
                throw new E_Clean_Exit();
            }
        }
        elseif (isset($_REQUEST['ngg_serve_fontawesome_css'])) {
            $fs = C_Fs::get_instance();
            $abspath = $fs->find_static_abspath('photocrati-nextgen_gallery_display#fontawesome/font-awesome.css');
            if ($abspath) {
                header('Content-Type: text/css');
                echo str_replace('fonts/fontawesome-webfont.woff', site_url('/?ngg_serve_fontawesome_woff=1'), file_get_contents($abspath));
                throw new E_Clean_Exit();
            }
        }
    }


	function no_resources_mode($valid_request=TRUE)
	{
		if (isset($_REQUEST['ngg_no_resources'])) {
			global $wp_scripts, $wp_styles;

			// Don't enqueue any stylesheets
			if ($wp_scripts)
				$wp_scripts->queue = $wp_styles->queue = array();

			// Don't run the resource manager
			$valid_request = FALSE;
		}

		return $valid_request;
	}

  function _render_related_string()
  {
      $settings = C_NextGen_Settings::get_instance();
      $type = $settings->appendType;
      $maxImages = $settings->maxImages;
      $sluglist = array();

      switch ($type) {
          case 'tags':
              if (function_exists('get_the_tags'))
              {
                  $taglist = get_the_tags();
                  if (is_array($taglist)) {
                      foreach ($taglist as $tag) {
                          $sluglist[] = $tag->slug;
                      }
                  }
              }
              break;
          case 'category':
              $catlist = get_the_category();
              if (is_array($catlist))
              {
                  foreach ($catlist as $cat) {
                      $sluglist[] = $cat->category_nicename;
                  }
              }
              break;
      }

      $taglist = implode(',', $sluglist);

      if ($taglist === 'uncategorized' || empty($taglist))
          return;

      $renderer = C_Component_Registry::get_instance()->get_utility('I_Displayed_Gallery_Renderer');
      $view     = C_Component_Registry::get_instance()->get_utility('I_Component_Factory')
                                                      ->create('mvc_view', '');
      $retval = $renderer->display_images(array(
          'source' => 'tags',
          'container_ids' => $taglist,
          'display_type' => NGG_BASIC_THUMBNAILS,
          'images_per_page' => $maxImages,
          'maximum_entity_count' => $maxImages,
          'template' => $view->get_template_abspath('photocrati-nextgen_gallery_display#related'),
          'show_all_in_lightbox' => FALSE,
          'show_slideshow_link' => FALSE,
          'disable_pagination' => TRUE,
          'display_no_images_error' => FALSE
      ));

      return apply_filters('ngg_show_related_gallery_content', $retval, $taglist);
  }

	function _render_related_images($content)
	{
    $settings = C_NextGen_Settings::get_instance();
      
		if ($settings->get('activateTags')) {
			$related = $this->_render_related_string();
			
			if ($related != null) {
		    $heading = $settings->relatedHeading;
				$content .= $heading . $related;
			}
		}
		
		return $content;
	}

    /**
     * Adds menu item to the admin bar
     */
    function add_admin_bar_menu()
    {
        global $wp_admin_bar;

        if ( current_user_can('NextGEN Change options') ) {
            $wp_admin_bar->add_menu(array(
                'parent' => 'ngg-menu',
                'id' => 'ngg-menu-display_settings',
                'title' => __('Gallery Settings', 'nggallery'),
                'href' => admin_url('admin.php?page=ngg_display_settings')
            ));
        }
    }

    /**
     * Registers our static settings resources so the ATP module can find them later
     */
    function _register_resources()
    {
		// Register custom post types for compatibility
        $types = array(
			'displayed_gallery'		=>	'NextGEN Gallery - Displayed Gallery',
			'display_type'			=>	'NextGEN Gallery - Display Type',
			'gal_display_source'	=>	'NextGEN Gallery - Displayed Gallery Source'
		);
		foreach ($types as $type => $label) {
			register_post_type($type, array(
				'label'		=>	$label,
				'publicly_queryable'	=>	FALSE,
				'exclude_from_search'	=>	TRUE,
			));
		}

		$router = $this->get_registry()->get_utility('I_Router');

        wp_register_script(
            'nextgen_gallery_display_settings',
            $router->get_static_url('photocrati-nextgen_gallery_display#nextgen_gallery_display_settings.js'),
            array('jquery-ui-accordion', 'jquery-ui-tooltip')
        );

        wp_register_style(
            'nextgen_gallery_display_settings',
            $router->get_static_url('photocrati-nextgen_gallery_display#nextgen_gallery_display_settings.css')
        );

        wp_register_style(
            'nextgen_gallery_related_images',
            $router->get_static_url('photocrati-nextgen_gallery_display#nextgen_gallery_related_images.css')
        );
        wp_enqueue_style('nextgen_gallery_related_images');

        wp_register_script(
            'jquery.nextgen_radio_toggle',
            $router->get_static_url('photocrati-nextgen_gallery_display#jquery.nextgen_radio_toggle.js'),
            array('jquery')
        );

        wp_register_script('ngg_common', $router->get_static_url('photocrati-nextgen_gallery_display#common.js'), array('jquery'));

        $pro_active = FALSE;
        if (defined('NGG_PRO_PLUGIN_VERSION'))
            $pro_active = 'NGG_PRO_PLUGIN_VERSION';
        if (defined('NEXTGEN_GALLERY_PRO_VERSION'))
            $pro_active = 'NEXTGEN_GALLERY_PRO_VERSION';
        if (!empty($pro_active))
            $pro_active = constant($pro_active);
        if (empty($pro_active) || version_compare($pro_active, '1.0.11') >= 0)
        {
            // Font Awesome
            if (wp_style_is('fontawesome', 'registered')) {
                wp_enqueue_style('fontawesome');
            }
            elseif (strpos(strtolower($_SERVER['SERVER_SOFTWARE']), 'microsoft-iis') !== FALSE) {
                wp_enqueue_style('fontawesome', site_url('/?ngg_serve_fontawesome_css=1'));
            }
            else {
                $router = C_Component_Registry::get_instance()->get_utility('I_Router');
                wp_enqueue_style('fontawesome', $router->get_static_url('photocrati-nextgen_gallery_display#fontawesome/font-awesome.css'));
            }
        }

        wp_register_style('ngg_trigger_buttons', $router->get_static_url('photocrati-nextgen_gallery_display#trigger_buttons.css'));
    }


	/**
	 * Adds the display settings page to wp-admin
	 */
	function add_display_settings_page()
	{
		add_submenu_page(
			NGGFOLDER,
			_('NextGEN Gallery & Album Settings'),
			_('Gallery Settings'),
			'NextGEN Change options',
			NGG_DISPLAY_SETTINGS_SLUG,
			array(&$this->controller, 'index_action')
		);
	}

	/**
	 * Provides the [display_images] shortcode
	 * @param array $params
	 * @param string $inner_content
	 * @return string
	 */
	function display_images($params, $inner_content=NULL)
	{
		$renderer = $this->get_registry()->get_utility('I_Displayed_Gallery_Renderer');
		return $renderer->display_images($params, $inner_content);
	}

    /**
     * Gets a value from the parameter array, and if not available, uses the default value
     *
     * @param string $name
     * @param mixed $default
     * @param array $params
     * @return mixed
     */
    function _get_param($name, $default, $params)
    {
        return (isset($params[$name])) ? $params[$name] : $default;
    }

    function get_type_list()
    {
        return array(
            'C_Displayed_Gallery_Trigger'           => 'class.displayed_gallery_trigger.php',
            'C_Displayed_Gallery_Trigger_Manager'   =>  'class.displayed_gallery_trigger_manager.php',
            'A_Displayed_Gallery_Trigger_Element'   =>  'adapter.displayed_gallery_trigger_element.php',
			'A_Gallery_Display_Ajax'		=>	'adapter.gallery_display_ajax.php',
            'A_Display_Settings_Controller' => 'adapter.display_settings_controller.php',
            'A_Display_Settings_Page' 		=> 'adapter.display_settings_page.php',
            'A_Gallery_Display_Factory' 	=> 'adapter.gallery_display_factory.php',
            'C_Gallery_Display_Installer' 	=> 'class.gallery_display_installer.php',
            'A_Gallery_Display_View' 		=> 'adapter.gallery_display_view.php',
            'C_Displayed_Gallery' 			=> 'class.displayed_gallery.php',
            'C_Displayed_Gallery_Mapper' 	=> 'class.displayed_gallery_mapper.php',
            'C_Displayed_Gallery_Renderer' 	=> 'class.displayed_gallery_renderer.php',
            'C_Displayed_Gallery_Source' 	=> 'class.displayed_gallery_source.php',
            'C_Displayed_Gallery_Source_Mapper' => 'class.displayed_gallery_source_mapper.php',
            'C_Display_Type' 				=> 'class.display_type.php',
            'C_Display_Type_Controller' 	=> 'class.display_type_controller.php',
            'C_Display_Type_Mapper' 		=> 'class.display_type_mapper.php',
            'Hook_Propagate_Thumbnail_Dimensions_To_Settings' => 'hook.propagate_thumbnail_dimensions_to_settings.php',
            'I_Displayed_Gallery' 			=> 'interface.displayed_gallery.php',
            'I_Displayed_Gallery_Mapper' 	=> 'interface.displayed_gallery_mapper.php',
            'I_Displayed_Gallery_Renderer' 	=> 'interface.displayed_gallery_renderer.php',
            'I_Displayed_Gallery_Source' 	=> 'interface.displayed_gallery_source.php',
            'I_Displayed_Gallery_Source_Mapper' => 'interface.displayed_gallery_source_mapper.php',
            'I_Display_Settings_Controller' => 'interface.display_settings_controller.php',
            'I_Display_Type' 				=> 'interface.display_type.php',
            'I_Display_Type_Controller' 	=> 'interface.display_type_controller.php',
            'I_Display_Type_Mapper' 		=> 'interface.display_type_mapper.php',
            'Mixin_Display_Type_Form' 		=> 'mixin.display_type_form.php'
        );
    }
}

new M_Gallery_Display();
