<?php
//* Start the engine
include_once( get_template_directory() . '/lib/init.php' );

//* Child theme (do not remove)
define( 'CHILD_THEME_NAME', 'Dora Dizajn' );
define( 'CHILD_THEME_URL', 'http://www.doradizajn.com/' );
define( 'CHILD_THEME_VERSION', '2.0.1' );

//* Enqueue Lato Google font
add_action( 'wp_enqueue_scripts', 'genesis_sample_google_fonts' );
function genesis_sample_google_fonts() {
	wp_enqueue_style( 'google-font-lato', '//fonts.googleapis.com/css?family=Lato:300,700', array(), CHILD_THEME_VERSION );
}

//* Add HTML5 markup structure
add_theme_support( 'html5' );

//* Add viewport meta tag for mobile browsers
add_theme_support( 'genesis-responsive-viewport' );

//* Add support for custom background
add_theme_support( 'custom-background' );

//* Add support for 3-column footer widgets
add_theme_support( 'genesis-footer-widgets', 1 );

add_image_size('home-1', 300, 150, true);


//* Customize the next page link
add_filter ( 'genesis_next_link_text' , 'sp_next_page_link' );
function sp_next_page_link ( $text ) {
	return g_ent( '&raquo; ' ) . __( 'Sledeća strana', CHILD_DOMAIN );
}

//* Customize the previous page link
add_filter ( 'genesis_prev_link_text' , 'sp_previous_page_link' );
function sp_previous_page_link ( $text ) {
	return g_ent( '&laquo; ' ) . __( 'Prethodna strana', CHILD_DOMAIN );
}

/** Adding slider widget */

add_action( 'genesis_before', 'my_slider_widget' );
   function my_slider_widget() {
        echo '<div class="slider-widget-area">';
        dynamic_sidebar('slider-widget-area');
        echo '</div>';
       
   }


/** Register slider widget area */
genesis_register_sidebar( array(
    'id'            => 'slider-widget-area',
    'name'          => __( 'Slajder', 'themename' ),
    'description'   => __( 'Widget area za slajder', 'themename' ),
) );



//* Customize the credits
add_filter( 'genesis_footer_creds_text', 'sp_footer_creds_text' );
function sp_footer_creds_text() {
	echo '<div class="creds" style="font-family:verdana;"><p>';
	echo 'Copyright &copy; ';
	echo date('Y');
	echo ' &middot; <a href="http://doradizajn.com">Dora Dizajn</a> &middot;';
	echo '</p></div>';
}
//* Remove the post info and entry meta in the entry footer (requires HTML5 theme support)
remove_action( 'genesis_entry_header', 'genesis_post_info', 12 );
remove_action( 'genesis_entry_footer', 'genesis_post_meta' );


/**  Breadcrumbs
add_action('genesis_before_entry', 'adding_breadcrumbs');
function adding_breadcrumbs() {
	if (in_category( 5 )) {
		if(qtrans_getLanguage()=='en')
		{
	the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'/en" rel="v:url" property="v:title">Home</a></span> / <span typeof="v:Breadcrumb"><a href="'.home_url().'/en/reference/" rel="v:url" property="v:title">Reference</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
		}
		else
		{
the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'" rel="v:url" property="v:title">Početna</a></span> / <span typeof="v:Breadcrumb"><a href="'.home_url().'/reference" rel="v:url" property="v:title">Reference</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
		}
	}
	if (in_category( 3 )) {
		if(qtrans_getLanguage()=='en')
		{
	the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'/en" rel="v:url" property="v:title">Home</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
		}
		else
		{
the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'" rel="v:url" property="v:title">Početna</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
		}
	}
	if (in_category( 4 )) {
		if(qtrans_getLanguage()=='en')
			{
	the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'/en" rel="v:url" property="v:title">Home</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
			}
		else
			{
the_title( '<p id="breadcrumbs"><span xmlns:v="http://rdf.data-vocabulary.org/#"><span typeof="v:Breadcrumb"><a href="'.home_url().'" rel="v:url" property="v:title">Početna</a></span> / <span typeof="v:Breadcrumb"><span class="breadcrumb_last" property="v:title">','</span></span></span></p>');
		}
	}
	if(!in_category( 4 ) and !in_category( 3 ) and !in_category( 5 ))
	{
		if ( function_exists('yoast_breadcrumb') ) {
		yoast_breadcrumb('<p id="breadcrumbs">','</p>');
		}
	}
	
}
*/

//* Read more link 

// Add Read More Link to Excerpts
add_filter('excerpt_more', 'get_read_more_link');
add_filter( 'the_content_more_link', 'get_read_more_link' );
function get_read_more_link() {
   return '...&nbsp;<a href="' . get_permalink() . '">[Read&nbsp;More]</a>';
}

add_filter( 'excerpt_more', 'child_read_more_link' ); 
add_filter( 'get_the_content_more_link', 'child_read_more_link' ); 
add_filter( 'the_content_more_link', 'child_read_more_link' ); 
function child_read_more_link() { 
	if(qtrans_getLanguage()=='en')
	{
	return '<a class="more-link" href="' .get_permalink() .'" rel="nofollow">Read more</a>';
	}
	else 
	{
	return '<a class="more-link" href="' .get_permalink() .'" rel="nofollow">Saznaj više</a>'; 
	}
} 

/** Remove Title & Description */
remove_action( 'genesis_site_title', 'genesis_seo_site_title' );
remove_action( 'genesis_site_description', 'genesis_seo_site_description' );

/** Homepage 

add_action('get_header', 'remove_loop');
function remove_loop() {
	if(is_front_page()) {

	}
}
add_action( 'genesis_before_loop', 'home_widget' );
   function home_widget() {
	if(is_front_page()) 
	{
        echo '<div class="home-1">';
        dynamic_sidebar('home-1');
        echo '</div>';
	echo '<div class="home-2">';
        dynamic_sidebar('home-2');
        echo '</div>';
	echo '<div class="home-3">';
        dynamic_sidebar('home-3');
        echo '</div>';
	}
       
	}
	
*/

/** Remove the post meta function for front page only **/
remove_action( 'genesis_after_post_content', 'genesis_post_meta' );
add_filter('genesis_pre_get_option_site_layout', '__genesis_return_full_width_content');